<?php
/* --------------------------------------------------------------
 MenuDataLoader.php 2020-02-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Gambio\Admin\Layout\Menu\AdminMenuService;
use Smarty;

/**
 * Class MenuDataLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class MenuDataLoader implements LoaderInterface
{
    /**
     * @var AdminMenuService
     */
    private $menuService;
    
    
    /**
     * MenuDataLoader constructor.
     *
     * @param AdminMenuService $menuService
     */
    public function __construct(
        AdminMenuService $menuService
    ) {
        $this->menuService = $menuService;
    }
    
    
    /**
     * Loads menu data and assign it to smarty.
     *
     * @param Smarty $smarty
     */
    public function load(Smarty $smarty): void
    {
        $smarty->assign('menu_entries', $this->menuService->getAdminMenu());
    }
}